/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreOverworldViewActionInvestigate;
import com.middlemindgames.TyreObjects.TyreOverworldViewActionSearch;
import com.middlemindgames.dat.ResourceContainer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TyreState {
    public int stepCount;
    public int searchCount;
    public int investigateCount;
    public int investigateFindCount;
    public int talkCount;
    public int searchFindCount;
    public int battleAmbushCount;
    public int battleAmbushWinCount;
    public int battleAmbushLossCount;
    public int battlePreemptiveCount;
    public int battlePreemptiveWinCount;
    public int battlePreemptiveLossCount;
    public int goldAccumulated;
    public int goldSpent;
    public int blowGlancingCount;
    public int blowMissedCount;
    public int blowUltimateCount;
    public int battleCount;
    public int battleWinCount;
    public int battleLossCount;
    public int escapeCount;
    public int escapeSuccessCount;
    public int escapeFailCount;
    public int healUse;
    public int antidoteUse;
    public int antisleepUse;
    public int enemiesKilled;
    public boolean[] flags;
    public int hitPoints;
    public int hitDamage;
    public int magicPoints;
    public int magicUsage;
    public int isPoisoned;
    public int isAsleep;
    public int isStunned;
    public int hasMap;
    public int hasCompass;
    public int hasOrbFire;
    public int hasOrbPoison;
    public int hasOrbSleep;
    public int hasOrbStun;
    public int hasStaffBlizzard;
    public int hasWarpSheet;

    public TyreState() {
        this.ImportState(GameSettings.SAVE_DIR_STATE);
    }

    private void SetField(String type, Field f, String val, Object obj) throws Exception {
        if (type != null && type.equals("int")) {
            f.setInt(obj, Integer.parseInt(val));
        } else if (type != null && type.equals("float")) {
            f.setFloat(obj, Float.parseFloat(val));
        } else if (type != null && type.equals("double")) {
            f.setDouble(obj, Double.parseDouble(val));
        } else if (type != null && type.equals("short")) {
            f.setShort(obj, Short.parseShort(val));
        } else if (type != null && type.equals("string")) {
            f.set(obj, val);
        } else if (type != null && type.equals("bool")) {
            f.setBoolean(obj, Boolean.parseBoolean(val));
        } else {
            f.setInt(obj, Integer.parseInt(val));
        }
    }

    public final boolean ImportState(String xmlDir) {
        File dir = new File(xmlDir);
        String[] files = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().contains(".xml");
            }
        });
        if (files == null || files.length == 0) {
            return false;
        }
        Arrays.sort(files, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                long i2;
                String ss1 = s1.replace(".xml", "");
                String ss2 = s2.replace(".xml", "");
                long i1 = Long.parseLong(ss1);
                if (i1 < (i2 = Long.parseLong(ss2))) {
                    return 1;
                }
                if (i1 > i2) {
                    return -1;
                }
                return 0;
            }
        });
        if (files == null || files.length == 0) {
            return false;
        }
        String file = xmlDir + files[0];
        TyreDatGameUtils.wr("Reading game state file: " + file);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(file));
            Node nodeMain = document.getElementsByTagName("state").item(0);
            String version = nodeMain.getAttributes().getNamedItem("version").getNodeValue();
            NodeList nodeList = nodeMain.getChildNodes();
            if (version != null && version.equals("1.0")) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1 || !node.getNodeName().equals("entry")) continue;
                    Element elem = (Element)node;
                    String key = node.getAttributes().getNamedItem("key").getNodeValue();
                    String val = node.getAttributes().getNamedItem("val").getNodeValue();
                    String from = node.getAttributes().getNamedItem("from").getNodeValue();
                    String type = "int";
                    if (node.getAttributes().getNamedItem("type") != null) {
                        type = node.getAttributes().getNamedItem("type").getNodeValue();
                    }
                    TyreDatGameUtils.wr("Found pc state entry with key: " + key + " Val: " + val + " From: " + from);
                    try {
                        Field f;
                        if (from.equals("TyreState")) {
                            if (key.equals("flags")) {
                                if (type == null || !type.equals("string")) continue;
                                this.DeserializeFlags(val);
                                continue;
                            }
                            f = TyreState.class.getField(key);
                            if (f == null) continue;
                            this.SetField(type, f, val, this);
                            continue;
                        }
                        if (from.equals("TyreOverworldViewActionSearch")) {
                            f = TyreOverworldViewActionSearch.class.getField(key);
                            if (f == null) continue;
                            this.SetField(type, f, val, null);
                            continue;
                        }
                        if (!from.equals("TyreOverworldViewActionInvestigate") || (f = TyreOverworldViewActionInvestigate.class.getField(key)) == null) continue;
                        this.SetField(type, f, val, null);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                System.out.println("Currently only supports version 1.0 of state save files.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public final boolean ExportState(String xmlDir) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
        Date date = new Date();
        String now = sdf.format(date);
        String xml = "";
        String file = xmlDir + now + ".xml";
        try {
            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
            xml = xml + "<state version=\"1.0\">\n";
            xml = xml + "<entry key=\"stepCount\" val=\"" + this.stepCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"battleCount\" val=\"" + this.battleCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"battleWinCount\" val=\"" + this.battleWinCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"battleLossCount\" val=\"" + this.battleLossCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"escapeCount\" val=\"" + this.escapeCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"escapeSuccessCount\" val=\"" + this.escapeSuccessCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"escapeFailCount\" val=\"" + this.escapeFailCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"healUse\" val=\"" + this.healUse + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"antidoteUse\" val=\"" + this.antidoteUse + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"antisleepUse\" val=\"" + this.antisleepUse + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"enemiesKilled\" val=\"" + this.enemiesKilled + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"hitPoints\" val=\"" + this.hitPoints + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"hitDamage\" val=\"" + this.hitDamage + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"magicPoints\" val=\"" + this.magicPoints + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"magicUsage\" val=\"" + this.magicUsage + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"isPoisoned\" val=\"" + this.isPoisoned + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"isAsleep\" val=\"" + this.isAsleep + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"hasMap\" val=\"" + this.hasMap + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"hasCompass\" val=\"" + this.hasCompass + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"hasOrbFire\" val=\"" + this.hasOrbFire + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"hasOrbPoison\" val=\"" + this.hasOrbPoison + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"hasOrbSleep\" val=\"" + this.hasOrbSleep + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"hasOrbStun\" val=\"" + this.hasOrbStun + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"hasStaffBlizzard\" val=\"" + this.hasStaffBlizzard + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"hasWarpSheet\" val=\"" + this.hasWarpSheet + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"flags\" val=\"" + this.SerializeFlags() + "\" type=\"string\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"searchCount\" val=\"" + this.searchCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"investigateCount\" val=\"" + this.investigateCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"talkCount\" val=\"" + this.talkCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"searchFindCount\" val=\"" + this.searchFindCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"investigateFindCount\" val=\"" + this.investigateFindCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"battleAmbushCount\" val=\"" + this.battleAmbushCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"battleAmbushWinCount\" val=\"" + this.battleAmbushWinCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"battleAmbushLossCount\" val=\"" + this.battleAmbushLossCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"battlePreemptiveCount\" val=\"" + this.battlePreemptiveCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"battlePreemptiveWinCount\" val=\"" + this.battlePreemptiveWinCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"battlePreemptiveLossCount\" val=\"" + this.battlePreemptiveLossCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"goldAccumulated\" val=\"" + this.goldAccumulated + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"goldSpent\" val=\"" + this.goldSpent + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"blowGlancingCount\" val=\"" + this.blowGlancingCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"blowMissedCount\" val=\"" + this.blowMissedCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"blowUltimateCount\" val=\"" + this.blowUltimateCount + "\" type=\"int\" from=\"TyreState\" />\n";
            xml = xml + "<entry key=\"SEARCH_COUNT_RECENT\" val=\"" + TyreOverworldViewActionSearch.SEARCH_COUNT_RECENT + "\" type=\"int\" from=\"TyreOverworldViewActionSearch\" />\n";
            xml = xml + "<entry key=\"INVESTIGATE_COUNT_RECENT\" val=\"" + TyreOverworldViewActionInvestigate.INVESTIGATE_COUNT_RECENT + "\" type=\"int\" from=\"TyreOverworldViewActionInvestigate\" />\n";
            xml = xml + "<entry key=\"SEARCH_COUNT_TOTAL\" val=\"" + TyreOverworldViewActionSearch.SEARCH_COUNT_TOTAL + "\" type=\"int\" from=\"TyreOverworldViewActionSearch\" />\n";
            xml = xml + "<entry key=\"INVESTIGATE_COUNT_TOTAL\" val=\"" + TyreOverworldViewActionInvestigate.INVESTIGATE_COUNT_TOTAL + "\" type=\"int\" from=\"TyreOverworldViewActionInvestigate\" />\n";
            xml = xml + "</state>\n";
            PrintWriter pw = new PrintWriter(file, "UTF-8");
            pw.write(xml);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String SerializeFlags() {
        this.flags = ResourceContainer.flags;
        int len = this.flags.length;
        String s = "";
        for (int i = 0; i < len; ++i) {
            s = this.flags[i] ? s + "1" : s + "0";
            if (i >= len - 1) continue;
            s = s + ",";
        }
        return s;
    }

    private void DeserializeFlags(String f) {
        String[] ss = f.split(",");
        this.flags = new boolean[ss.length];
        int len = this.flags.length;
        for (int i = 0; i < len; ++i) {
            this.flags[i] = ss[i].equals("1");
        }
        ResourceContainer.flags = this.flags;
    }

    public int GetStepCount() {
        return this.stepCount;
    }

    public void SetStepCount(int stepCount) {
        this.stepCount = stepCount;
    }

    public int GetBattleCount() {
        return this.battleCount;
    }

    public void SetBattleCount(int battleCount) {
        this.battleCount = battleCount;
    }

    public int GetBattleWinCount() {
        return this.battleWinCount;
    }

    public void SetBattleWinCount(int battleWinCount) {
        this.battleWinCount = battleWinCount;
    }

    public int GetBattleLossCount() {
        return this.battleLossCount;
    }

    public void SetBattleLossCount(int battleLossCount) {
        this.battleLossCount = battleLossCount;
    }

    public int GetEscapeCount() {
        return this.escapeCount;
    }

    public void SetEscapeCount(int escapeCount) {
        this.escapeCount = escapeCount;
    }

    public int GetEscapeSuccessCount() {
        return this.escapeSuccessCount;
    }

    public void SetEscapeSuccessCount(int escapeSuccessCount) {
        this.escapeSuccessCount = escapeSuccessCount;
    }

    public int GetEscapeFailCount() {
        return this.escapeFailCount;
    }

    public void SetEscapeFailCount(int escapeFailCount) {
        this.escapeFailCount = escapeFailCount;
    }

    public int GetHealUse() {
        return this.healUse;
    }

    public void SetHealUse(int healUse) {
        this.healUse = healUse;
    }

    public int GetAntidoteUse() {
        return this.antidoteUse;
    }

    public void SetAntidoteUse(int antidoteUse) {
        this.antidoteUse = antidoteUse;
    }

    public int GetAntisleepUse() {
        return this.antisleepUse;
    }

    public void SetAntisleepUse(int antisleepUse) {
        this.antisleepUse = antisleepUse;
    }

    public int GetEnemiesKilled() {
        return this.enemiesKilled;
    }

    public void SetEnemiesKilled(int enemiesKilled) {
        this.enemiesKilled = enemiesKilled;
    }

    public boolean[] GetFlags() {
        return this.flags;
    }

    public void SetFlags(boolean[] flags) {
        this.flags = flags;
    }

    public int GetHitPoints() {
        return this.hitPoints;
    }

    public void SetHitPoints(int hitPoints) {
        this.hitPoints = hitPoints;
    }

    public int GetHitDamage() {
        return this.hitDamage;
    }

    public void SetHitDamage(int hitDamage) {
        this.hitDamage = hitDamage;
    }

    public int GetMagicPoints() {
        return this.magicPoints;
    }

    public void SetMagicPoints(int magicPoints) {
        this.magicPoints = magicPoints;
    }

    public int GetMagicUsage() {
        return this.magicUsage;
    }

    public void SetMagicUsage(int magicUsage) {
        this.magicUsage = magicUsage;
    }

    public int GetIsPoisoned() {
        return this.isPoisoned;
    }

    public void SetIsPoisoned(int isPoisoned) {
        this.isPoisoned = isPoisoned;
    }

    public int GetIsAsleep() {
        return this.isAsleep;
    }

    public void SetIsAsleep(int isAsleep) {
        this.isAsleep = isAsleep;
    }

    public int GetIsStunned() {
        return this.isStunned;
    }

    public void SetIsStunned(int isStunned) {
        this.isStunned = isStunned;
    }
}

