/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.CollisionResult;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreTile;
import com.middlemindgames.dat.ResourceContainer;
import com.middlemindgames.dat.RoomData;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgRect;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreRoomData
extends MmgObj {
    public static boolean EXTEND_CANT_WALK_REGIONS = true;
    private RoomData datObj;
    private boolean ready;
    private MmgBmp img;
    private BufferedImage bg;
    private Graphics2D bgGraphics;
    private MmgPen p;
    private TyreTile tile;
    private MmgRect tr1;
    private MmgRect tr2;
    private int tw;
    private int th;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private boolean pause = false;

    public TyreRoomData(RoomData t) {
        this.SetDatObj(t);
        this.img = null;
        this.ready = false;
        this.LoadResources();
    }

    public TyreRoomData(RoomData t, MmgBmp lImg) {
        this.SetDatObj(t);
        this.img = lImg;
        this.ready = true;
    }

    public final int GetTileId() {
        return this.datObj.tiles_id;
    }

    public final int GetDatLeft() {
        return this.datObj.left;
    }

    public final int GetDatRight() {
        return this.datObj.right;
    }

    public final int GetDatTop() {
        return this.datObj.top;
    }

    public final int GetDatBottom() {
        return this.datObj.bottom;
    }

    public final boolean GetCanWalk() {
        return this.tile.GetCanWalk();
    }

    public final CollisionResult CollidesWith(int lx, int ly) {
        this.tr1 = new MmgRect(this.GetPosition(), this.GetWidth(), this.GetHeight());
        this.tr2 = new MmgRect(lx, ly, ly + 1, lx + 1);
        this.tw = 1;
        this.th = 1;
        CollisionResult cret = new CollisionResult(true);
        if (this.tr1.GetLeft() < this.tr2.GetLeft() && this.tr2.GetLeft() < this.tr1.GetRight() && this.tr1.GetTop() < this.tr2.GetTop() && this.tr2.GetTop() < this.tr1.GetBottom() || this.tr2.GetLeft() < this.tr1.GetLeft() && this.tr1.GetLeft() < this.tr2.GetRight() && this.tr2.GetTop() < this.tr1.GetTop() && this.tr1.GetTop() < this.tr2.GetBottom()) {
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_RIGHT) {
                TyreDatGameUtils.wr("PC Right: " + this.tr2.GetLeft() + "," + this.tr2.GetRight() + " PC Dim: " + this.tr2.GetWidth() + "x" + this.tr2.GetHeight() + " Box Left: " + this.tr1.GetLeft() + "," + this.tr1.GetRight() + " Box Dim: " + this.tr1.GetWidth() + "x" + this.tr1.GetHeight());
                return new CollisionResult(new MmgVector2(this.tr2.GetRight() - this.tr1.GetLeft(), this.tr2.GetTop() - this.tr1.GetTop()), false);
            }
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_LEFT) {
                return new CollisionResult(new MmgVector2(this.tr2.GetLeft() - this.tr1.GetRight(), this.tr2.GetTop() - this.tr1.GetTop()), false);
            }
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_BACK) {
                return new CollisionResult(new MmgVector2(this.tr2.GetLeft() + this.tr1.GetLeft(), this.tr2.GetTop() - this.tr1.GetBottom()), false);
            }
            if (GamePanel.PC.GetCurrentDir() == DatConstants.NPC_DIR_FRONT) {
                return new CollisionResult(new MmgVector2(this.tr2.GetLeft() - this.tr1.GetLeft(), this.tr2.GetBottom() - this.tr1.GetTop()), false);
            }
        }
        return cret;
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final RoomData GetDatObj() {
        return this.datObj;
    }

    public final void SetDatObj(RoomData t) {
        this.datObj = t;
        if (!this.datObj.processed) {
            if (this.datObj.right == 255) {
                this.datObj.right = 256;
            }
            if (this.datObj.right == 7) {
                this.datObj.right = 8;
            }
            if (this.datObj.left == 255) {
                this.datObj.left = 256;
            }
            if (this.datObj.left == 7) {
                this.datObj.left = 8;
            }
            if (this.datObj.bottom == 255) {
                this.datObj.bottom = 256;
            }
            if (this.datObj.bottom == 7) {
                this.datObj.bottom = 8;
            }
            if (this.datObj.top == 255) {
                this.datObj.top = 256;
            }
            if (this.datObj.top == 7) {
                this.datObj.top = 8;
            }
            if (this.datObj.right % 8 != 0 && (this.datObj.right + 1) % 8 == 0) {
                ++this.datObj.right;
            }
            if (this.datObj.left % 8 != 0 && (this.datObj.left + 1) % 8 == 0) {
                ++this.datObj.left;
            }
            if (this.datObj.bottom % 8 != 0 && (this.datObj.bottom + 1) % 8 == 0) {
                ++this.datObj.bottom;
            }
            if (this.datObj.top % 8 != 0 && (this.datObj.top + 1) % 8 == 0) {
                ++this.datObj.top;
            }
            if (this.datObj.right % 8 != 0 && (this.datObj.right - 1) % 8 == 0) {
                --this.datObj.right;
            }
            if (this.datObj.left % 8 != 0 && (this.datObj.left - 1) % 8 == 0) {
                --this.datObj.left;
            }
            if (this.datObj.bottom % 8 != 0 && (this.datObj.bottom - 1) % 8 == 0) {
                --this.datObj.bottom;
            }
            if (this.datObj.top % 8 != 0 && (this.datObj.top - 1) % 8 == 0) {
                --this.datObj.top;
            }
            if (EXTEND_CANT_WALK_REGIONS && !ResourceContainer.tiles[this.datObj.tiles_id].canWalk) {
                if (this.datObj.top == 0) {
                    this.datObj.top -= DatConstants.PC_ORIG_HEIGHT;
                }
                if (this.datObj.bottom == 160) {
                    this.datObj.bottom += DatConstants.PC_ORIG_HEIGHT;
                }
                if (this.datObj.left == 0) {
                    this.datObj.left -= DatConstants.PC_ORIG_WIDTH;
                }
                if (this.datObj.right == 256) {
                    this.datObj.right += DatConstants.PC_ORIG_WIDTH;
                }
            }
            this.datObj.processed = true;
        }
        this.left = MmgHelper.ScaleValue((int)(this.datObj.left * 2));
        this.right = MmgHelper.ScaleValue((int)(this.datObj.right * 2));
        this.top = MmgHelper.ScaleValue((int)(this.datObj.top * 2));
        this.bottom = MmgHelper.ScaleValue((int)(this.datObj.bottom * 2));
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    private void PrepBuffers(int w, int h) {
        this.bg = this.create(w, h, false);
        this.bgGraphics = (Graphics2D)this.bg.getGraphics();
    }

    private BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final void LoadResources() {
        this.pause = true;
        this.tile = new TyreTile(ResourceContainer.tiles[this.datObj.tiles_id]);
        int l = this.left;
        int r = this.right;
        int t = this.top;
        int b = this.bottom;
        int w = r - l;
        int h = b - t;
        int ntw = MmgHelper.ScaleValue((int)DatConstants.TILE_WIDTH);
        int nth = MmgHelper.ScaleValue((int)DatConstants.TILE_HEIGHT);
        if (w < ntw) {
            w = (r += MmgHelper.ScaleValue((int)DatConstants.TILE_WIDTH)) - l;
        }
        if (h < nth) {
            h = (b += MmgHelper.ScaleValue((int)DatConstants.TILE_HEIGHT)) - t;
        }
        if (this.bgGraphics == null) {
            this.PrepBuffers(w, h);
        }
        this.p = new MmgPen();
        this.p.SetGraphics((Graphics)this.bgGraphics);
        this.p.SetAdvRenderHints();
        this.SetPosition(new MmgVector2(l, t));
        for (int i = 0; i < w; i += this.tile.GetWidth()) {
            for (int j = 0; j < h; j += this.tile.GetHeight()) {
                this.tile.SetPosition(new MmgVector2(i, j));
                this.tile.MmgDraw(this.p);
            }
        }
        this.img = new MmgBmp((Image)this.bg);
        this.p = null;
        this.bgGraphics = null;
        this.bg = null;
        this.ready = true;
        this.pause = false;
    }

    public final void UnloadResources() {
        this.pause = true;
        this.img = null;
        this.tile = null;
        this.p = null;
        this.bgGraphics = null;
        this.bg = null;
        this.ready = false;
    }

    public final TyreRoomData Clone() {
        TyreRoomData ret = new TyreRoomData(this.datObj);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.GetPosition());
        }
    }

    public final int GetWidth() {
        return this.img.GetWidth();
    }

    public final void SetWidth(int i) {
        this.img.SetWidth(i);
    }

    public final int GetHeight() {
        return this.img.GetHeight();
    }

    public final void SetHeight(int i) {
        this.img.SetHeight(i);
    }
}

