/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.CollisionResult;
import com.middlemindgames.TyreGame.DatConstants;
import com.middlemindgames.TyreGame.GamePanel;
import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.TyreObjects.TyreLinkTable;
import com.middlemindgames.TyreObjects.TyreNpc;
import com.middlemindgames.TyreObjects.TyreObject;
import com.middlemindgames.TyreObjects.TyreObjectCompare;
import com.middlemindgames.TyreObjects.TyreOverworldView;
import com.middlemindgames.dat.ResourceContainer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmpScaler;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public final class TyreObjectSet
extends MmgObj {
    private final boolean OVERRIDE_PC_ENTRY = true;
    private boolean mirrorPc = false;
    private MmgVector2 mirrorPcOffset;
    private int[] datObj;
    private boolean ready;
    private MmgBmp img;
    private TyreObject[] objects;
    private TyreObject[] cwObjects;
    private TyreObject[] spObjects;
    private BufferedImage bg;
    private Graphics2D bgGraphics;
    private MmgPen p;
    private boolean hasNpc;
    private boolean hasBattle;
    private boolean hasLink;
    private boolean hasSearch;
    private boolean dirty;
    private final TyreObject fakePc;
    private TyreOverworldView.RoomViewIndex roomViewIndex;
    private int tlen;
    private int tlen2;
    private int ti;
    private int ttlen;
    private int ttlen2;
    private int tti;
    private CollisionResult cret;
    private int clen;
    private int ci;
    private CollisionResult ccret;
    private int cclen;
    private int cci;
    private CollisionResult cretfa;
    private int clenfa;
    private int cifa;
    private final TyreObjectCompare comp;
    private boolean lret;
    private Color dc;
    private TyreLinkTable owner;
    private boolean pause = false;

    public TyreObjectSet(int[] t, TyreLinkTable o) {
        this.owner = o;
        this.comp = new TyreObjectCompare();
        this.roomViewIndex = TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        this.fakePc = TyreObject.GetPcPlaceHolder();
        this.hasNpc = false;
        this.SetDatObj(t);
        this.img = null;
        this.ready = false;
        this.mirrorPc = false;
        this.dirty = false;
        this.LoadResources();
    }

    public TyreObjectSet(int[] t, Graphics2D g, BufferedImage lbg, TyreLinkTable o) {
        this.owner = o;
        this.comp = new TyreObjectCompare();
        this.roomViewIndex = TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        this.fakePc = TyreObject.GetPcPlaceHolder();
        this.hasNpc = false;
        this.bgGraphics = g;
        this.bg = lbg;
        this.SetDatObj(t);
        this.img = null;
        this.ready = false;
        this.mirrorPc = false;
        this.dirty = false;
        this.LoadResources();
    }

    public TyreObjectSet(int[] t, MmgBmp lImg, TyreLinkTable o) {
        this.owner = o;
        this.comp = new TyreObjectCompare();
        this.roomViewIndex = TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_NONE;
        this.fakePc = TyreObject.GetPcPlaceHolder();
        this.hasNpc = false;
        this.SetDatObj(t);
        this.ready = false;
        this.mirrorPc = false;
        this.dirty = false;
        this.LoadResources();
        this.img = lImg;
    }

    public TyreLinkTable GetOwner() {
        return this.owner;
    }

    public void SetOwner(TyreLinkTable o) {
        this.owner = o;
    }

    public final CollisionResult CollidesWith(int x, int y, boolean ignorePc) {
        this.cret = new CollisionResult(true);
        this.clen = this.cwObjects.length;
        this.ci = 0;
        while (this.ci < this.clen) {
            if (ignorePc) {
                if (this.cwObjects[this.ci].GetType() != DatConstants.OBJECT_TYPE_PC) {
                    this.cret = this.cwObjects[this.ci].CollidesWith(x, y);
                    if (!this.cret.CanWalk()) {
                        break;
                    }
                }
            } else {
                this.cret = this.cwObjects[this.ci].CollidesWith(x, y);
                if (!this.cret.CanWalk()) break;
            }
            ++this.ci;
        }
        return this.cret;
    }

    public final CollisionResult CollidesWithContains(int x, int y, boolean ignorePc, int w, int h) {
        this.cret = new CollisionResult(true);
        this.clen = this.cwObjects.length;
        this.ci = 0;
        while (this.ci < this.clen) {
            if (ignorePc) {
                if (this.cwObjects[this.ci].GetType() != DatConstants.OBJECT_TYPE_PC) {
                    this.cret = this.cwObjects[this.ci].CollidesWithContains(x, y, w, h);
                    if (!this.cret.CanWalk()) {
                        break;
                    }
                }
            } else {
                this.cret = this.cwObjects[this.ci].CollidesWithContains(x, y, w, h);
                if (!this.cret.CanWalk()) break;
            }
            ++this.ci;
        }
        return this.cret;
    }

    public final CollisionResult CollidesWithContained(int x, int y, boolean ignorePc, int w, int h) {
        this.cret = new CollisionResult(true);
        this.clen = this.cwObjects.length;
        this.ci = 0;
        while (this.ci < this.clen) {
            if (ignorePc) {
                if (this.cwObjects[this.ci].GetType() != DatConstants.OBJECT_TYPE_PC) {
                    this.cret = this.cwObjects[this.ci].CollidesWithContained(x, y, w, h);
                    if (!this.cret.CanWalk()) {
                        break;
                    }
                }
            } else {
                this.cret = this.cwObjects[this.ci].CollidesWithContained(x, y, w, h);
                if (!this.cret.CanWalk()) break;
            }
            ++this.ci;
        }
        return this.cret;
    }

    public final CollisionResult CollidesWithPseudoDepthContains(int x, int y, boolean ignorePc, int w, int h) {
        this.cret = new CollisionResult(true);
        this.clen = this.cwObjects.length;
        this.ci = 0;
        while (this.ci < this.clen) {
            if (ignorePc) {
                if (this.cwObjects[this.ci].GetType() != DatConstants.OBJECT_TYPE_PC) {
                    this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepthContains(x, y, w, h);
                    if (!this.cret.CanWalk()) {
                        break;
                    }
                }
            } else {
                this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepthContains(x, y, w, h);
                if (!this.cret.CanWalk()) break;
            }
            ++this.ci;
        }
        return this.cret;
    }

    public final CollisionResult CollidesWithPseudoDepthContained(int x, int y, boolean ignorePc, int w, int h) {
        this.cret = new CollisionResult(true);
        this.clen = this.cwObjects.length;
        this.ci = 0;
        while (this.ci < this.clen) {
            if (ignorePc) {
                if (this.cwObjects[this.ci].GetType() != DatConstants.OBJECT_TYPE_PC) {
                    this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepthContained(x, y, w, h);
                    if (!this.cret.CanWalk()) {
                        break;
                    }
                }
            } else {
                this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepthContained(x, y, w, h);
                if (!this.cret.CanWalk()) break;
            }
            ++this.ci;
        }
        return this.cret;
    }

    public final CollisionResult CollidesWithPseudoDepthContains(int x, int y, TyreNpc ignoreNpc, int w, int h) {
        this.cret = new CollisionResult(true);
        this.clen = this.cwObjects.length;
        this.ci = 0;
        while (this.ci < this.clen) {
            if (ignoreNpc != null && this.cwObjects[this.ci].GetType() == DatConstants.OBJECT_TYPE_NPC) {
                if (!((Object)((Object)this.cwObjects[this.ci].GetNpc())).equals((Object)ignoreNpc)) {
                    this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepthContains(x, y, w, h);
                    if (!this.cret.CanWalk()) {
                        break;
                    }
                }
            } else {
                this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepthContains(x, y, w, h);
                if (!this.cret.CanWalk()) break;
            }
            ++this.ci;
        }
        return this.cret;
    }

    public final CollisionResult CollidesWithPseudoDepthContained(int x, int y, TyreNpc ignoreNpc, int w, int h) {
        this.cret = new CollisionResult(true);
        this.clen = this.cwObjects.length;
        this.ci = 0;
        while (this.ci < this.clen) {
            if (ignoreNpc != null && this.cwObjects[this.ci].GetType() == DatConstants.OBJECT_TYPE_NPC) {
                if (!((Object)((Object)this.cwObjects[this.ci].GetNpc())).equals((Object)ignoreNpc)) {
                    this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepthContained(x, y, w, h);
                    if (!this.cret.CanWalk()) {
                        break;
                    }
                }
            } else {
                this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepthContained(x, y, w, h);
                if (!this.cret.CanWalk()) break;
            }
            ++this.ci;
        }
        return this.cret;
    }

    public final CollisionResult CollidesWithForBattle(int x, int y) {
        this.cretfa = new CollisionResult(true);
        if (this.hasBattle) {
            this.clenfa = this.spObjects.length;
            this.cifa = 0;
            while (this.cifa < this.clenfa) {
                if (this.spObjects[this.cifa].GetType() == DatConstants.OBJECT_TYPE_ENEMY) {
                    this.cretfa = this.spObjects[this.cifa].CollidesWith(x, y);
                    if (!this.cretfa.CanWalk()) {
                        this.cretfa.SetCollidedWith(this.spObjects[this.cifa]);
                        break;
                    }
                }
                ++this.cifa;
            }
        }
        return this.cretfa;
    }

    public final CollisionResult CollidesWithForBattleContains(int x, int y, int w, int h) {
        this.cretfa = new CollisionResult(true);
        if (this.hasBattle) {
            this.clenfa = this.spObjects.length;
            this.cifa = 0;
            while (this.cifa < this.clenfa) {
                if (this.spObjects[this.cifa].GetType() == DatConstants.OBJECT_TYPE_ENEMY) {
                    this.cretfa = this.spObjects[this.cifa].CollidesWithContains(x, y, w, h);
                    if (!this.cretfa.CanWalk()) {
                        this.cretfa.SetCollidedWith(this.spObjects[this.cifa]);
                        break;
                    }
                }
                ++this.cifa;
            }
        }
        return this.cretfa;
    }

    public final CollisionResult CollidesWithForBattleContained(int x, int y, int w, int h) {
        this.cretfa = new CollisionResult(true);
        if (this.hasBattle) {
            this.clenfa = this.spObjects.length;
            this.cifa = 0;
            while (this.cifa < this.clenfa) {
                if (this.spObjects[this.cifa].GetType() == DatConstants.OBJECT_TYPE_ENEMY) {
                    this.cretfa = this.spObjects[this.cifa].CollidesWithContained(x, y, w, h);
                    if (!this.cretfa.CanWalk()) {
                        this.cretfa.SetCollidedWith(this.spObjects[this.cifa]);
                        break;
                    }
                }
                ++this.cifa;
            }
        }
        return this.cretfa;
    }

    public final CollisionResult CollidesWithForSearch(int x, int y) {
        this.cretfa = new CollisionResult(true);
        if (this.hasSearch) {
            this.clenfa = this.objects.length;
            this.cifa = 0;
            while (this.cifa < this.clenfa) {
                if (this.objects[this.cifa].GetType() == DatConstants.OBJECT_TYPE_HIDDEN_ITEM) {
                    this.cretfa = this.objects[this.cifa].CollidesWith(x, y);
                    if (!this.cretfa.CanWalk()) {
                        this.cretfa.SetCollidedWith(this.objects[this.cifa]);
                        break;
                    }
                }
                ++this.cifa;
            }
        }
        return this.cretfa;
    }

    public final CollisionResult CollidesWithForLink(int x, int y) {
        this.cretfa = new CollisionResult(true);
        if (this.hasLink) {
            this.clenfa = this.spObjects.length;
            this.cifa = 0;
            while (this.cifa < this.clenfa) {
                if (this.spObjects[this.cifa].GetType() == DatConstants.OBJECT_TYPE_LINK_TABLE) {
                    this.cretfa = this.spObjects[this.cifa].CollidesWith(x, y);
                    if (!this.cretfa.CanWalk()) {
                        this.cretfa.SetCollidedWith(this.spObjects[this.cifa]);
                        break;
                    }
                }
                ++this.cifa;
            }
        }
        return this.cretfa;
    }

    public final CollisionResult CollidesWithForLinkContains(int x, int y, int w, int h) {
        this.cretfa = new CollisionResult(true);
        if (this.hasLink) {
            this.clenfa = this.spObjects.length;
            this.cifa = 0;
            while (this.cifa < this.clenfa) {
                if (this.spObjects[this.cifa].GetType() == DatConstants.OBJECT_TYPE_LINK_TABLE) {
                    this.cretfa = this.spObjects[this.cifa].CollidesWithContains(x, y, w, h);
                    if (!this.cretfa.CanWalk()) {
                        this.cretfa.SetCollidedWith(this.spObjects[this.cifa]);
                        break;
                    }
                }
                ++this.cifa;
            }
        }
        return this.cretfa;
    }

    public final CollisionResult CollidesWithForLinkContained(int x, int y, int w, int h) {
        this.cretfa = new CollisionResult(true);
        if (this.hasLink) {
            this.clenfa = this.spObjects.length;
            this.cifa = 0;
            while (this.cifa < this.clenfa) {
                if (this.spObjects[this.cifa].GetType() == DatConstants.OBJECT_TYPE_LINK_TABLE) {
                    this.cretfa = this.spObjects[this.cifa].CollidesWithContained(x, y, w, h);
                    if (!this.cretfa.CanWalk()) {
                        this.cretfa.SetCollidedWith(this.spObjects[this.cifa]);
                        break;
                    }
                }
                ++this.cifa;
            }
        }
        return this.cretfa;
    }

    public final CollisionResult CollidesWithForSearchContains(int x, int y, int w, int h) {
        this.cretfa = new CollisionResult(true);
        this.clenfa = this.objects.length;
        this.cifa = 0;
        while (this.cifa < this.clenfa) {
            if (this.objects[this.cifa].GetType() == DatConstants.OBJECT_TYPE_HIDDEN_ITEM) {
                this.cretfa = this.objects[this.cifa].CollidesWithContains(x, y, w, h);
                if (!this.cretfa.CanWalk()) {
                    this.cretfa.SetCollidedWith(this.objects[this.cifa]);
                    break;
                }
            }
            ++this.cifa;
        }
        return this.cretfa;
    }

    public final CollisionResult CollidesWithForSearchContained(int x, int y, int w, int h) {
        this.cretfa = new CollisionResult(true);
        this.clenfa = this.objects.length;
        this.cifa = 0;
        while (this.cifa < this.clenfa) {
            if (this.objects[this.cifa].GetType() == DatConstants.OBJECT_TYPE_HIDDEN_ITEM) {
                this.cretfa = this.objects[this.cifa].CollidesWithContained(x, y, w, h);
                if (!this.cretfa.CanWalk()) {
                    this.cretfa.SetCollidedWith(this.objects[this.cifa]);
                    break;
                }
            }
            ++this.cifa;
        }
        return this.cretfa;
    }

    public final CollisionResult CollidesWithForInvestigate(int x, int y, boolean ignorePc) {
        this.cretfa = new CollisionResult(true);
        this.clenfa = this.cwObjects.length;
        this.cifa = 0;
        while (this.cifa < this.clenfa) {
            if (ignorePc) {
                if (this.cwObjects[this.cifa].GetType() != DatConstants.OBJECT_TYPE_PC) {
                    this.cretfa = this.cwObjects[this.cifa].CollidesWith(x, y);
                    if (!this.cretfa.CanWalk()) {
                        this.cretfa.SetCollidedWith(this.cwObjects[this.cifa]);
                        break;
                    }
                }
            } else {
                this.cretfa = this.cwObjects[this.cifa].CollidesWith(x, y);
                if (!this.cretfa.CanWalk()) {
                    this.cretfa.SetCollidedWith(this.cwObjects[this.cifa]);
                    break;
                }
            }
            ++this.cifa;
        }
        return this.cretfa;
    }

    public final CollisionResult CollidesWithPseudoDepth(int x, int y, boolean ignorePc) {
        this.cret = new CollisionResult(true);
        this.clen = this.cwObjects.length;
        this.ci = 0;
        while (this.ci < this.clen) {
            if (ignorePc) {
                if (this.cwObjects[this.ci].GetType() != DatConstants.OBJECT_TYPE_PC) {
                    this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepth(x, y);
                    if (!this.cret.CanWalk()) {
                        break;
                    }
                }
            } else {
                this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepth(x, y);
                if (!this.cret.CanWalk()) break;
            }
            ++this.ci;
        }
        return this.cret;
    }

    public final CollisionResult CollidesWithPseudoDepth(int x, int y, TyreNpc ignoreNpc) {
        this.cret = new CollisionResult(true);
        this.clen = this.cwObjects.length;
        this.ci = 0;
        while (this.ci < this.clen) {
            if (ignoreNpc != null && this.cwObjects[this.ci].GetType() == DatConstants.OBJECT_TYPE_NPC) {
                if (!((Object)((Object)this.cwObjects[this.ci].GetNpc())).equals((Object)ignoreNpc)) {
                    this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepth(x, y);
                    if (!this.cret.CanWalk()) {
                        break;
                    }
                }
            } else {
                this.cret = this.cwObjects[this.ci].CollidesWithPseudoDepth(x, y);
                if (!this.cret.CanWalk()) break;
            }
            ++this.ci;
        }
        return this.cret;
    }

    public final CollisionResult CollidesWith(int x, int y, int ignore, boolean ignorePc) {
        this.ccret = new CollisionResult(true);
        if (this.cwObjects != null && this.cwObjects.length > 0) {
            this.cclen = this.cwObjects.length;
            this.cci = 0;
            while (this.cci < this.cclen) {
                if (ignorePc) {
                    if (this.cwObjects[this.ci].GetType() != DatConstants.OBJECT_TYPE_PC && this.cci != ignore) {
                        this.ccret = this.cwObjects[this.cci].CollidesWith(x, y);
                        if (!this.ccret.CanWalk()) {
                            break;
                        }
                    }
                } else if (this.cci != ignore) {
                    this.ccret = this.cwObjects[this.cci].CollidesWith(x, y);
                    if (!this.ccret.CanWalk()) break;
                }
                ++this.cci;
            }
        }
        return this.ccret;
    }

    public final CollisionResult CollidesWithPseudoDepth(int x, int y, int ignore, boolean ignorePc) {
        this.ccret = new CollisionResult(true);
        if (this.cwObjects != null && this.cwObjects.length > 0) {
            this.cclen = this.cwObjects.length;
            this.cci = 0;
            while (this.cci < this.cclen) {
                if (ignorePc) {
                    if (this.cwObjects[this.ci].GetType() != DatConstants.OBJECT_TYPE_PC && this.cci != ignore) {
                        this.ccret = this.cwObjects[this.cci].CollidesWithPseudoDepth(x, y);
                        if (!this.ccret.CanWalk()) {
                            break;
                        }
                    }
                } else if (this.cci != ignore) {
                    this.ccret = this.cwObjects[this.cci].CollidesWithPseudoDepth(x, y);
                    if (!this.ccret.CanWalk()) break;
                }
                ++this.cci;
            }
        }
        return this.ccret;
    }

    public final TyreOverworldView.RoomViewIndex GetRoomViewIndex() {
        return this.roomViewIndex;
    }

    public final void SetRoomViewIndex(TyreOverworldView.RoomViewIndex v) {
        this.roomViewIndex = v;
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final boolean HasSearch() {
        return this.hasSearch;
    }

    public final boolean HasBattle() {
        return this.hasBattle;
    }

    public final boolean HasLink() {
        return this.hasLink;
    }

    public final boolean HasNpc() {
        return this.hasNpc;
    }

    public final boolean HasPc() {
        if (GamePanel.PC == null) {
            return false;
        }
        return GamePanel.PC.GetRoomViewIndex() == this.GetRoomViewIndex() && this.GetRoomViewIndex() != TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_NONE && this.GetRoomViewIndex() != TyreOverworldView.RoomViewIndex.ROOM_VIEW_INDEX_ALL;
    }

    public final int[] GetDatObj() {
        return this.datObj;
    }

    public final void SetDatObj(int[] t) {
        this.datObj = t;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    public boolean IsMirrorPc() {
        return this.mirrorPc;
    }

    public void SetMirrorPc(boolean b) {
        this.mirrorPc = b;
    }

    public boolean IsDirty() {
        return this.dirty;
    }

    public void SetDirty(boolean b) {
        this.dirty = b;
    }

    public final MmgVector2 GetMirrorPcOffset() {
        return this.mirrorPcOffset;
    }

    public final void SetMirrorPcOffset(MmgVector2 v) {
        this.mirrorPcOffset = v;
    }

    public final TyreObject[] GetCantWalkObjects() {
        return this.cwObjects;
    }

    public final TyreObject[] GetSpecialObjects() {
        return this.spObjects;
    }

    public final TyreObject[] GetObjects() {
        return this.objects;
    }

    private void PrepBuffers(int w, int h) {
        this.bg = this.create(w, h, true);
        this.bgGraphics = (Graphics2D)this.bg.getGraphics();
    }

    private BufferedImage create(int width, int height, boolean alpha) {
        return MmgBmpScaler.GRAPHICS_CONFIG.createCompatibleImage(width, height, alpha ? 3 : 1);
    }

    public final void LoadResources() {
        this.pause = true;
        if (this.datObj != null && this.datObj.length > 0) {
            int len = this.datObj.length;
            this.objects = new TyreObject[len];
            ArrayList<TyreObject> cwo = new ArrayList<TyreObject>();
            ArrayList<TyreObject> spo = new ArrayList<TyreObject>();
            boolean foundPc = false;
            if (this.OVERRIDE_PC_ENTRY) {
                foundPc = true;
                cwo.add(this.fakePc);
            }
            for (int i = 0; i < len; ++i) {
                if (GameSettings.FLAGS_DRAWING_ON && !TyreDatGameUtils.IsFlagActive(ResourceContainer.objects[this.datObj[i]].flagIndex)) continue;
                this.objects[i] = new TyreObject(ResourceContainer.objects[this.datObj[i]], this.owner);
                if (this.objects[i] != null && (this.objects[i].GetType() == DatConstants.OBJECT_TYPE_CANT_WALK || this.objects[i].GetType() == DatConstants.OBJECT_TYPE_NPC || this.objects[i].GetType() == DatConstants.OBJECT_TYPE_PC || this.objects[i].GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET_CANT_WALK)) {
                    if (this.objects[i].GetType() == DatConstants.OBJECT_TYPE_NPC) {
                        this.hasNpc = true;
                        cwo.add(this.objects[i]);
                        continue;
                    }
                    if (this.objects[i].GetType() == DatConstants.OBJECT_TYPE_PC) {
                        foundPc = true;
                        if (this.OVERRIDE_PC_ENTRY) continue;
                        cwo.add(this.objects[i]);
                        continue;
                    }
                    cwo.add(this.objects[i]);
                    continue;
                }
                if (this.objects[i].GetType() == DatConstants.OBJECT_TYPE_ENEMY) {
                    this.hasBattle = true;
                    spo.add(this.objects[i]);
                    continue;
                }
                if (this.objects[i].GetType() == DatConstants.OBJECT_TYPE_LINK_TABLE) {
                    this.hasLink = true;
                    spo.add(this.objects[i]);
                    continue;
                }
                if (this.objects[i].GetType() != DatConstants.OBJECT_TYPE_HIDDEN_ITEM) continue;
                this.hasSearch = true;
            }
            if (!foundPc) {
                cwo.add(this.fakePc);
            }
            this.cwObjects = new TyreObject[cwo.size()];
            this.cwObjects = cwo.toArray(this.cwObjects);
            this.spObjects = new TyreObject[spo.size()];
            this.spObjects = spo.toArray(this.spObjects);
        } else {
            this.objects = null;
            this.cwObjects = null;
            this.spObjects = null;
        }
        if (this.bgGraphics == null) {
            this.w = MmgHelper.ScaleValue((int)DatConstants.ROOM_WIDTH);
            this.h = MmgHelper.ScaleValue((int)DatConstants.ROOM_HEIGHT);
            this.PrepBuffers(this.w, this.h);
        }
        this.p = new MmgPen();
        this.p.SetGraphics((Graphics)this.bgGraphics);
        this.p.SetAdvRenderHints();
        this.DrawScreen();
        this.ready = true;
        this.pause = false;
    }

    public final void DrawScreen() {
        this.pause = true;
        this.dirty = false;
        if (this.datObj != null && this.datObj.length > 0) {
            this.ttlen = this.datObj.length;
            this.ttlen2 = this.cwObjects.length;
            this.tti = 0;
            this.tti = 0;
            while (this.tti < this.ttlen) {
                if (this.objects[this.tti] != null && (this.objects[this.tti].GetType() == DatConstants.OBJECT_TYPE_CAN_WALK_OVER_DYNAMIC || this.objects[this.tti].GetType() == DatConstants.OBJECT_TYPE_CAN_WALK_OVER_NEGATIVE_POSITION || this.objects[this.tti].GetType() == DatConstants.OBJECT_TYPE_CAN_WALK_OVER_ROTATION || this.objects[this.tti].GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET || this.objects[this.tti].GetType() == DatConstants.OBJECT_TYPE_OBJECT_SET_ROTATION)) {
                    this.objects[this.tti].MmgDraw(this.p);
                }
                ++this.tti;
            }
            if (TyreLinkTable.SHOW_HIDDEN_ITEMS || TyreLinkTable.SHOW_HIDDEN_LINKS || TyreLinkTable.SHOW_HIDDEN_ENEMIES) {
                this.tti = 0;
                while (this.tti < this.ttlen) {
                    if (this.objects[this.tti] != null && this.objects[this.tti].GetType() == DatConstants.OBJECT_TYPE_HIDDEN_ITEM && TyreLinkTable.SHOW_HIDDEN_ITEMS) {
                        this.objects[this.tti].MmgDraw(this.p);
                    } else if (this.objects[this.tti] != null && this.objects[this.tti].GetType() == DatConstants.OBJECT_TYPE_ENEMY && TyreLinkTable.SHOW_HIDDEN_ENEMIES) {
                        this.objects[this.tti].MmgDraw(this.p);
                    } else if (this.objects[this.tti] != null && this.objects[this.tti].GetType() == DatConstants.OBJECT_TYPE_LINK_TABLE && TyreLinkTable.SHOW_HIDDEN_LINKS) {
                        this.objects[this.tti].MmgDraw(this.p);
                    }
                    ++this.tti;
                }
            }
            if (this.cwObjects != null && this.cwObjects.length > 0) {
                if (this.mirrorPc) {
                    Arrays.sort(this.cwObjects, this.comp);
                    this.tti = 0;
                    while (this.tti < this.ttlen2) {
                        if (this.cwObjects[this.tti].GetType() == DatConstants.OBJECT_TYPE_PC) {
                            this.p.DrawBmp(GamePanel.PC.GetCurrentFrame(), GamePanel.PC.GetX() + this.mirrorPcOffset.GetX(), GamePanel.PC.GetY() + this.mirrorPcOffset.GetY());
                        } else if (this.cwObjects[this.tti].GetType() != DatConstants.OBJECT_TYPE_NPC || this.cwObjects[this.tti].GetType() == DatConstants.OBJECT_TYPE_NPC && this.cwObjects[this.tti].IsTreeFolk()) {
                            this.cwObjects[this.tti].MmgDraw(this.p);
                        }
                        ++this.tti;
                    }
                } else if (this.HasPc()) {
                    Arrays.sort(this.cwObjects, this.comp);
                    this.tti = 0;
                    while (this.tti < this.ttlen2) {
                        if (this.cwObjects[this.tti].GetType() == DatConstants.OBJECT_TYPE_PC) {
                            GamePanel.PC.MmgDraw(this.p);
                            if (TyreLinkTable.SHOW_COLLISION_BOX) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.RED);
                                this.p.DrawRect((MmgObj)GamePanel.PC);
                                this.p.GetGraphics().setColor(this.dc);
                            }
                            if (TyreLinkTable.SHOW_PSEUDO_DEPTH_COLLISION_BOX) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.ORANGE);
                                this.p.DrawRect(GamePanel.PC.GetPseudoDepthCollisionRect());
                                this.p.GetGraphics().setColor(this.dc);
                            }
                            if (TyreLinkTable.SHOW_SEARCH_COLLISION_BOX) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.MAGENTA);
                                this.p.DrawRect(GamePanel.PC.GetSearchCollisionRect());
                                this.p.GetGraphics().setColor(this.dc);
                            }
                            if (TyreLinkTable.SHOW_INVESTIGATE_COLLISION_BOX) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.CYAN);
                                this.p.DrawRect(GamePanel.PC.GetInvestigateCollisionRect());
                                this.p.GetGraphics().setColor(this.dc);
                            }
                            if (TyreLinkTable.SHOW_PSEUDO_DEPTH_WALK_COLLISION_BOX && GamePanel.PC.GetCurrentState() == DatConstants.NPC_STATE_WALKING) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.MAGENTA);
                                this.p.DrawRect(GamePanel.PC.GetPseudoDepthWalkCollisionRect());
                                this.p.GetGraphics().setColor(this.dc);
                            }
                            if (TyreLinkTable.FORCE_PSEUDO_DEPTH_WALK_COLLISION_BOX) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.MAGENTA);
                                this.p.DrawRect(GamePanel.PC.GetProjectedPseudoDepthWalkCollisionRect(GamePanel.PC.GetCurrentDir()));
                                this.p.GetGraphics().setColor(this.dc);
                            }
                        } else if (this.cwObjects[this.tti].GetType() == DatConstants.OBJECT_TYPE_NPC) {
                            this.cwObjects[this.tti].MmgDraw(this.p);
                            if (TyreLinkTable.SHOW_COLLISION_BOX) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.RED);
                                this.p.DrawRect((MmgObj)this.cwObjects[this.tti].GetNpc());
                                this.p.GetGraphics().setColor(this.dc);
                            }
                            if (TyreLinkTable.SHOW_PSEUDO_DEPTH_COLLISION_BOX) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.ORANGE);
                                this.p.DrawRect(this.cwObjects[this.tti].GetNpc().GetPseudoDepthCollisionRect());
                                this.p.GetGraphics().setColor(this.dc);
                            }
                            if (TyreLinkTable.SHOW_PSEUDO_DEPTH_WALK_COLLISION_BOX && this.cwObjects[this.tti].GetNpc().GetCurrentState() == DatConstants.NPC_STATE_WALKING) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.MAGENTA);
                                this.p.DrawRect(this.cwObjects[this.tti].GetNpc().GetPseudoDepthWalkCollisionRect());
                                this.p.GetGraphics().setColor(this.dc);
                            }
                        } else if (this.cwObjects[this.tti].GetType() == DatConstants.OBJECT_TYPE_CANT_WALK) {
                            this.cwObjects[this.tti].MmgDraw(this.p);
                            if (TyreLinkTable.SHOW_COLLISION_BOX) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.RED);
                                this.p.DrawRect((MmgObj)this.img, this.GetPosition());
                                this.p.GetGraphics().setColor(this.dc);
                            }
                            if (TyreLinkTable.SHOW_PSEUDO_DEPTH_COLLISION_BOX) {
                                this.dc = this.p.GetGraphics().getColor();
                                this.p.GetGraphics().setColor(Color.ORANGE);
                                this.p.DrawRect(this.cwObjects[this.tti].GetPseudoDepthCollisionRect());
                                this.p.GetGraphics().setColor(this.dc);
                            }
                        } else {
                            this.cwObjects[this.tti].MmgDraw(this.p);
                        }
                        ++this.tti;
                    }
                } else {
                    this.tti = 0;
                    while (this.tti < this.ttlen2) {
                        if (this.cwObjects[this.tti].GetType() != DatConstants.OBJECT_TYPE_PC && (TyreLinkTable.NPC_RENDER_MODE != TyreNpc.NpcRenderMode.GAME || this.cwObjects[this.tti].GetType() != DatConstants.OBJECT_TYPE_NPC)) {
                            this.cwObjects[this.tti].MmgDraw(this.p);
                        }
                        ++this.tti;
                    }
                }
            }
            this.tti = 0;
            while (this.tti < this.ttlen) {
                if (this.objects[this.tti] != null && this.objects[this.tti].GetType() == DatConstants.OBJECT_TYPE_CAN_WALK_UNDER_NEGATIVE_POSITION) {
                    this.objects[this.tti].MmgDraw(this.p);
                }
                ++this.tti;
            }
        }
        this.img = new MmgBmp((Image)this.bg);
        this.pause = false;
    }

    public final void UnloadResources() {
        this.pause = true;
        this.img = null;
        this.bgGraphics = null;
        this.bg = null;
        this.p = null;
        this.cwObjects = null;
        this.spObjects = null;
        if (this.objects != null && this.objects.length > 0) {
            this.tlen = this.objects.length;
            this.ti = 0;
            while (this.ti < this.tlen) {
                this.objects[this.ti].UnloadResources();
                ++this.ti;
            }
        }
        this.objects = null;
        this.ready = false;
    }

    public final TyreObjectSet Clone() {
        TyreObjectSet ret = new TyreObjectSet(this.datObj, this.owner);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        ret.SetRoomViewIndex(this.GetRoomViewIndex());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.GetPosition());
        }
    }

    public final boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        this.lret = false;
        if (this.isVisible && this.cwObjects != null && this.cwObjects.length > 0) {
            this.tlen = this.cwObjects.length;
            this.ti = 0;
            while (this.ti < this.tlen) {
                if (this.mirrorPc) {
                    this.lret = true;
                } else if (this.HasPc() && this.cwObjects[this.ti].GetType() == DatConstants.OBJECT_TYPE_PC) {
                    if (GamePanel.PC.MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                        this.lret = true;
                    }
                } else if (this.cwObjects[this.ti].MmgUpdate(updateTick, currentTimeMs, msSinceLastFrame)) {
                    this.lret = true;
                }
                ++this.ti;
            }
            if (this.dirty) {
                this.lret = true;
            }
            if (this.lret) {
                this.DrawScreen();
            }
        }
        return this.lret;
    }

    public final int GetWidth() {
        return this.img.GetWidth();
    }

    public final void SetWidth(int i) {
        this.img.SetWidth(i);
    }

    public final int GetHeight() {
        return this.img.GetHeight();
    }

    public final void SetHeight(int i) {
        this.img.SetHeight(i);
    }
}

