/*
 * Decompiled with CFR 0.152.
 */
package com.middlemindgames.TyreObjects;

import com.middlemindgames.TyreGame.GameSettings;
import com.middlemindgames.TyreGame.TyreDatGameUtils;
import com.middlemindgames.dat.Item;
import com.middlemindgames.dat.ResourceContainer;
import net.middlemind.MmgGameApiJava.MmgBase.MmgBmp;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;

public final class TyreItem
extends MmgObj {
    private Item datObj;
    private boolean ready;
    private MmgBmp img;
    private String imgId;
    private boolean pause = false;

    public TyreItem(Item itm) {
        this.SetDatObj(itm);
        this.img = null;
        this.ready = false;
        this.LoadResources();
    }

    public TyreItem(Item itm, MmgBmp lImg) {
        this.SetDatObj(itm);
        this.img = lImg;
        this.ready = true;
    }

    public final int GetItemType() {
        return this.datObj.type;
    }

    public final int GetAttackPoints() {
        return this.datObj.ap;
    }

    public final int GetCost() {
        return this.datObj.cost;
    }

    public final int GetFlagIndex() {
        return this.datObj.flagsIndex;
    }

    public final int GetReadStringIndex() {
        return this.datObj.readStringsIndex;
    }

    public final int GetNameStringIndex() {
        return this.datObj.stringIndex;
    }

    public final int GetImageIndex() {
        return this.datObj.imageIndex;
    }

    public final String GetNameString() {
        return ResourceContainer.strings[this.datObj.stringIndex];
    }

    public final String GetReadString() {
        return ResourceContainer.strings[this.datObj.readStringsIndex];
    }

    public final boolean GetFlagState() {
        return ResourceContainer.flags[this.datObj.flagsIndex];
    }

    public final boolean IsReady() {
        return this.ready;
    }

    public final void SetReady(boolean b) {
        this.ready = b;
    }

    public final Item GetDatObj() {
        return this.datObj;
    }

    public final void SetDatObj(Item itm) {
        this.datObj = itm;
        this.imgId = GameSettings.BMP_PREFIX + this.datObj.imageIndex;
    }

    public final String GetImageId() {
        return this.imgId;
    }

    public final MmgBmp GetImage() {
        return this.img;
    }

    public final void SetImage(MmgBmp lImg) {
        this.img = lImg;
    }

    public final void LoadResources() {
        this.img = TyreDatGameUtils.GetDatCachedBmp(this.datObj.imageIndex, this.imgId);
        this.ready = true;
    }

    public final void UnloadResources() {
        this.pause = true;
        this.img = null;
        this.imgId = null;
        this.ready = false;
    }

    public final TyreItem Clone() {
        TyreItem ret = new TyreItem(this.datObj);
        ret.SetPosition(this.GetPosition());
        ret.SetWidth(this.GetWidth());
        ret.SetHeight(this.GetHeight());
        return ret;
    }

    public final void MmgDraw(MmgPen p) {
        if (!this.pause && this.isVisible) {
            p.DrawBmp(this.img, this.GetPosition());
        }
    }

    public final int GetWidth() {
        return this.img.GetWidth();
    }

    public final void SetWidth(int i) {
        this.img.SetWidth(i);
    }

    public final int GetHeight() {
        return this.img.GetHeight();
    }

    public final void SetHeight(int i) {
        this.img.SetHeight(i);
    }
}

