/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import net.middlemind.MmgGameApiJava.MmgBase.MmgApiUtils;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgScreenData {
    public final int DEFAULT_WIDTH = 1024;
    public final int DEFAULT_HEIGHT = 768;
    private static int gameWidth;
    private static int gameHeight;
    private static int gameLeft;
    private static int gameTop;
    private static int screenWidth;
    private static int screenHeight;
    private static double scaleX;
    private static double scaleY;
    private static boolean scaleXOn;
    private static boolean scaleYOn;
    private static MmgVector2 scaleVec;
    private static MmgVector2 posVec;

    public MmgScreenData() {
        gameWidth = 1024;
        gameHeight = 768;
        gameLeft = 0;
        gameTop = 0;
        screenWidth = 1024;
        screenHeight = 768;
        scaleX = 1.0;
        scaleY = 1.0;
        scaleVec = new MmgVector2(scaleX, scaleY);
        posVec = new MmgVector2(gameLeft, gameTop);
    }

    public MmgScreenData(int w, int h) {
        gameWidth = w;
        gameHeight = h;
        gameLeft = 0;
        gameTop = 0;
        screenWidth = w;
        screenHeight = h;
        scaleX = 1.0;
        scaleY = 1.0;
        scaleVec = new MmgVector2(scaleX, scaleY);
        posVec = new MmgVector2(gameLeft, gameTop);
    }

    public MmgScreenData(int ScreenWidth, int ScreenHeight, int GameWidth, int GameHeight) {
        screenWidth = ScreenWidth;
        screenHeight = ScreenHeight;
        gameWidth = GameWidth;
        gameHeight = GameHeight;
        MmgScreenData.CalculateScaleAndOffset();
        scaleVec = new MmgVector2(scaleX, scaleY);
        posVec = new MmgVector2(gameLeft, gameTop);
    }

    public static String ToString() {
        String ret = "";
        ret = ret + "Screen Width: " + MmgScreenData.GetScreenWidth() + System.lineSeparator();
        ret = ret + "Screen Height: " + MmgScreenData.GetScreenHeight() + System.lineSeparator();
        ret = ret + "Game Width: " + MmgScreenData.GetGameWidth() + System.lineSeparator();
        ret = ret + "Game Height: " + MmgScreenData.GetGameHeight() + System.lineSeparator();
        ret = ret + "Game Offset X: " + MmgScreenData.GetGameLeft() + System.lineSeparator();
        ret = ret + "Game Offset Y: " + MmgScreenData.GetGameTop() + System.lineSeparator();
        ret = ret + "Scale X: " + MmgScreenData.GetScaleX() + System.lineSeparator();
        ret = ret + "Scale Y: " + MmgScreenData.GetScaleY() + System.lineSeparator();
        return ret;
    }

    public static int GetGameWidth() {
        return gameWidth;
    }

    public static void SetGameWidth(int w) {
        gameWidth = w;
    }

    public static int GetGameTop() {
        return gameTop;
    }

    public static void SetGameTop(int t) {
        gameTop = t;
    }

    public static int GetGameLeft() {
        return gameLeft;
    }

    public static void SetGameLeft(int l) {
        gameLeft = l;
    }

    public static int GetGameHeight() {
        return gameHeight;
    }

    public static void SetGameHeight(int h) {
        gameHeight = h;
    }

    public static void SetScreenWidth(int w) {
        screenWidth = w;
    }

    public static int GetScreenWidth() {
        return screenWidth;
    }

    public static void SetScreenHeight(int h) {
        screenHeight = h;
    }

    public static int GetScreenHeight() {
        return screenHeight;
    }

    public static double GetScaleX() {
        return scaleX;
    }

    public static void SetScaleX(double x) {
        scaleX = x;
    }

    public static double GetScaleY() {
        return scaleY;
    }

    public static void SetScaleY(double y) {
        scaleY = y;
    }

    public static boolean GetScaleXOn() {
        return scaleXOn;
    }

    public static void SetScaleXOn(boolean b) {
        scaleXOn = b;
    }

    public static boolean GetScaleYOn() {
        return scaleYOn;
    }

    public static void SetScaleYOn(boolean b) {
        scaleYOn = b;
    }

    public static MmgVector2 GetScale() {
        return scaleVec;
    }

    public static MmgVector2 GetPosition() {
        return posVec;
    }

    private static void CalculateTop() {
        gameTop = (screenHeight - gameHeight) / 2;
    }

    private static void CalculateLeft() {
        gameLeft = (screenWidth - gameWidth) / 2;
    }

    private static void CalculateScaleX() {
        int count;
        double test = 32.0;
        int panic = 5000;
        int resIi = 0;
        double dir = -1.0;
        double diff = 0.0;
        double prctDiffX = (double)screenWidth / (double)gameWidth;
        dir = -1.0;
        double resF = test * prctDiffX;
        double resI = (int)resF;
        resIi = (int)resI;
        diff = Math.abs(resF - resI);
        for (count = 0; (diff > 0.01 || resIi % 2 != 0) && count < panic; ++count) {
            resF = test * (prctDiffX += dir * 2.5E-4);
            resI = (int)resF;
            resIi = (int)resI;
            diff = Math.abs(resF - resI);
        }
        scaleXOn = true;
        scaleYOn = true;
        scaleX = prctDiffX;
        scaleY = prctDiffX;
        gameWidth = (int)((double)gameWidth * scaleX);
        gameHeight = (int)((double)gameHeight * scaleY);
        MmgScreenData.CalculateTop();
        MmgScreenData.CalculateLeft();
        MmgApiUtils.wr("Found X Scale: " + prctDiffX + ", ResF: " + resF + ", ResI: " + resI + ", Diff: " + diff + ", Count: " + count);
    }

    private static void CalculateScaleY() {
        int count;
        double test = 32.0;
        int panic = 5000;
        int resIi = 0;
        double dir = -1.0;
        double diff = 0.0;
        double prctDiffY = (double)screenHeight / (double)gameHeight;
        dir = -1.0;
        double resF = test * prctDiffY;
        double resI = (int)resF;
        resIi = (int)resI;
        diff = Math.abs(resF - resI);
        for (count = 0; (diff > 0.01 || resIi % 2 != 0) && count < panic; ++count) {
            resF = test * (prctDiffY += dir * 2.5E-4);
            resI = (int)resF;
            resIi = (int)resI;
            diff = Math.abs(resF - resI);
        }
        scaleXOn = true;
        scaleYOn = true;
        scaleX = prctDiffY;
        scaleY = prctDiffY;
        gameWidth = (int)((double)gameWidth * scaleX);
        gameHeight = (int)((double)gameHeight * scaleY);
        MmgScreenData.CalculateTop();
        MmgScreenData.CalculateLeft();
        MmgApiUtils.wr("Found Y Scale: " + prctDiffY + ", ResF: " + resF + ", ResI: " + resI + ", Diff: " + diff + ", Count: " + count);
    }

    public static void CalculateScaleAndOffset() {
        if (screenHeight == gameHeight && screenWidth == gameWidth) {
            scaleX = 1.0;
            scaleY = 1.0;
            gameTop = 0;
            gameLeft = 0;
        } else {
            boolean sX = true;
            boolean sY = true;
            MmgApiUtils.wr("ScaleX: " + sX + " ScaleY: " + sY);
            if (sX && !sY) {
                MmgScreenData.CalculateScaleX();
            } else if (sY && !sX) {
                MmgScreenData.CalculateScaleY();
            } else if (sX && sY) {
                MmgScreenData.CalculateScaleX();
                if (gameHeight > screenHeight) {
                    MmgScreenData.CalculateScaleY();
                }
            }
        }
    }
}

