/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import net.middlemind.MmgGameApiJava.MmgBase.MmgColor;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgObj {
    protected MmgVector2 pos;
    protected int w;
    protected int h;
    protected boolean isVisible;
    protected MmgColor color;
    private final String version = "1.0.1";
    protected boolean hasParent;
    protected MmgObj parent;
    protected String name;
    protected String mmgUid;

    public MmgObj() {
        this.pos = MmgVector2.GetOriginVec();
        this.w = 0;
        this.h = 0;
        this.isVisible = true;
        this.color = MmgColor.GetWhite();
        this.hasParent = false;
        this.parent = null;
        this.name = "";
        this.mmgUid = "";
    }

    public MmgObj(String n, String i) {
        this.pos = MmgVector2.GetOriginVec();
        this.w = 0;
        this.h = 0;
        this.isVisible = true;
        this.color = MmgColor.GetWhite();
        this.hasParent = false;
        this.parent = null;
        this.name = n;
        this.mmgUid = i;
    }

    public MmgObj(int X, int Y, int W, int H, boolean isv, MmgColor c) {
        this.pos = new MmgVector2(X, Y);
        this.w = W;
        this.h = H;
        this.isVisible = isv;
        this.color = c;
        this.hasParent = false;
        this.parent = null;
        this.name = "";
        this.mmgUid = "";
    }

    public MmgObj(int X, int Y, int W, int H, boolean isv, MmgColor c, String n, String i) {
        this.pos = new MmgVector2(X, Y);
        this.w = W;
        this.h = H;
        this.isVisible = isv;
        this.color = c;
        this.hasParent = false;
        this.parent = null;
        this.name = n;
        this.mmgUid = i;
    }

    public MmgObj(MmgVector2 v2, int W, int H, boolean isv, MmgColor c) {
        this.pos = v2;
        this.w = W;
        this.h = H;
        this.isVisible = isv;
        this.color = c;
        this.hasParent = false;
        this.parent = null;
        this.name = "";
        this.mmgUid = "";
    }

    public MmgObj(MmgVector2 v2, int W, int H, boolean isv, MmgColor c, String n, String i) {
        this.pos = v2;
        this.w = W;
        this.h = H;
        this.isVisible = isv;
        this.color = c;
        this.hasParent = false;
        this.parent = null;
        this.name = n;
        this.mmgUid = i;
    }

    public MmgObj(MmgObj obj) {
        if (obj.GetPosition() != null) {
            this.SetPosition(obj.GetPosition().Clone());
        } else {
            this.SetPosition(obj.GetPosition());
        }
        this.SetWidth(obj.GetWidth());
        this.SetHeight(obj.GetHeight());
        this.SetIsVisible(obj.GetIsVisible());
        if (obj.GetMmgColor() != null) {
            this.SetMmgColor(obj.GetMmgColor().Clone());
        } else {
            this.SetMmgColor(obj.GetMmgColor());
        }
        this.SetHasParent(obj.GetHasParent());
        this.SetParent(obj.GetParent());
        this.SetName(obj.GetName());
        this.SetId(obj.GetId());
    }

    public MmgObj Clone() {
        MmgObj ret = new MmgObj(this);
        return ret;
    }

    public String GetVersion() {
        return "1.0.1";
    }

    public void MmgDraw(MmgPen p) {
        if (this.isVisible) {
            // empty if block
        }
    }

    public boolean MmgUpdate(int updateTick, long currentTimeMs, long msSinceLastFrame) {
        if (this.isVisible) {
            // empty if block
        }
        return false;
    }

    public boolean GetIsVisible() {
        return this.isVisible;
    }

    public void SetIsVisible(boolean bl) {
        this.isVisible = bl;
    }

    public int GetWidth() {
        return this.w;
    }

    public void SetWidth(int W) {
        this.w = W;
    }

    public int GetHeight() {
        return this.h;
    }

    public void SetHeight(int H) {
        this.h = H;
    }

    public void SetPosition(MmgVector2 v) {
        this.pos = v;
    }

    public MmgVector2 GetPosition() {
        return this.pos;
    }

    public MmgColor GetMmgColor() {
        return this.color;
    }

    public void SetMmgColor(MmgColor c) {
        this.color = c;
    }

    public void SetX(int inX) {
        this.GetPosition().SetX(inX);
    }

    public int GetX() {
        return this.GetPosition().GetX();
    }

    public void SetY(int inY) {
        this.GetPosition().SetY(inY);
    }

    public int GetY() {
        return this.GetPosition().GetY();
    }

    public String GetName() {
        return this.name;
    }

    public void SetName(String n) {
        this.name = n;
    }

    public String GetId() {
        return this.mmgUid;
    }

    public void SetId(String i) {
        this.mmgUid = i;
    }

    public void SetHasParent(boolean b) {
        this.hasParent = b;
    }

    public void SetParent(MmgObj o) {
        this.parent = o;
    }

    public boolean GetHasParent() {
        return this.hasParent;
    }

    public MmgObj GetParent() {
        return this.parent;
    }

    public String ToString() {
        return "Name: " + this.GetName() + " Id: " + this.GetId() + " - " + this.GetPosition();
    }

    public boolean Equals(MmgObj o) {
        return o != null && o.GetHasParent() == this.GetHasParent() && o.GetIsVisible() == this.GetIsVisible() && o.GetHeight() == this.GetHeight() && (o.GetId() == null && this.GetId() == null || o.GetId() != null && this.GetId() != null && o.GetId().equals(this.GetId())) && (o.GetName() == null && this.GetName() == null || o.GetName() != null && this.GetName() != null && o.GetName().equals(this.GetName())) && (o.GetParent() == null && this.GetParent() == null || o.GetParent() != null && this.GetParent() != null && o.GetParent().Equals(this.GetParent())) && (o.GetPosition() == null && this.GetPosition() == null || o.GetPosition() != null && this.GetPosition() != null && o.GetPosition().Equals(this.GetPosition()));
    }
}

