/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import java.awt.Font;
import net.middlemind.MmgGameApiJava.MmgBase.MmgColor;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFont;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFontData;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgLabelValuePair
extends MmgObj {
    private MmgFont lbl;
    private MmgFont val;
    private int paddingX;
    private boolean skipReset = true;

    public MmgLabelValuePair() {
        this.SetLabel(new MmgFont(MmgFontData.GetFontBold()));
        this.SetValue(new MmgFont(MmgFontData.GetFontNorm()));
        this.SetPaddingX(8);
        this.SetWidth(0);
        this.SetHeight(0);
        this.skipReset = false;
        this.Reset();
    }

    public MmgLabelValuePair(Font fontLbl, Font fontVal) {
        this.SetLabel(new MmgFont(fontLbl));
        this.SetValue(new MmgFont(fontVal));
        this.SetPaddingX(8);
        this.SetWidth(0);
        this.SetHeight(0);
        this.skipReset = false;
        this.Reset();
    }

    public MmgLabelValuePair(MmgObj obj) {
        super(obj);
        this.SetLabel(new MmgFont());
        this.SetValue(new MmgFont());
        this.SetPaddingX(8);
        this.SetWidth(0);
        this.SetHeight(0);
        this.skipReset = false;
        this.Reset();
    }

    public MmgLabelValuePair(MmgLabelValuePair lvp) {
        if (lvp.GetLabel() == null) {
            this.SetLabel(lvp.GetLabel());
        } else {
            this.SetLabel(lvp.GetLabel().Clone());
        }
        if (lvp.GetValue() == null) {
            this.SetValue(lvp.GetValue());
        } else {
            this.SetValue(lvp.GetValue().Clone());
        }
        if (lvp.GetPosition() == null) {
            this.SetPosition(lvp.GetPosition());
        } else {
            this.SetPosition(lvp.GetPosition().Clone());
        }
        this.SetIsVisible(lvp.GetIsVisible());
        if (lvp.GetMmgColor() == null) {
            this.SetMmgColor(lvp.GetMmgColor());
        } else {
            this.SetMmgColor(lvp.GetMmgColor().Clone());
        }
        this.SetPaddingX(8);
        this.SetWidth(lvp.GetWidth());
        this.SetHeight(lvp.GetHeight());
        this.skipReset = false;
        this.Reset();
    }

    public MmgLabelValuePair(Font fontLbl, String txtLbl, Font fontVal, String txtVal, MmgVector2 pos, MmgColor cl) {
        this.SetLabel(new MmgFont(fontLbl));
        this.SetValue(new MmgFont(fontVal));
        this.SetLabelText(txtLbl);
        this.SetValueText(txtVal);
        this.SetPosition(pos);
        this.SetIsVisible(true);
        this.SetMmgColor(cl);
        this.SetPaddingX(8);
        this.skipReset = false;
        this.Reset();
    }

    public MmgLabelValuePair(Font fontLbl, String txtLbl, Font fontVal, String txtVal, int x, int y, MmgColor cl) {
        this.SetLabel(new MmgFont(fontLbl));
        this.SetValue(new MmgFont(fontVal));
        this.SetLabelText(txtLbl);
        this.SetValueText(txtVal);
        this.SetPosition(new MmgVector2(x, y));
        this.SetIsVisible(true);
        this.SetMmgColor(cl);
        this.SetPaddingX(8);
        this.skipReset = false;
        this.Reset();
    }

    @Override
    public MmgObj Clone() {
        MmgLabelValuePair ret = new MmgLabelValuePair(this);
        return ret;
    }

    public int GetPaddingX() {
        return this.paddingX;
    }

    public void SetPaddingX(int p) {
        this.paddingX = p;
        this.Reset();
    }

    public String GetValueText() {
        return this.val.GetText();
    }

    public void SetValueText(String s) {
        this.val.SetText(s);
        this.Reset();
    }

    public String GetLabelText() {
        return this.lbl.GetText();
    }

    public void SetLabelText(String s) {
        this.lbl.SetText(s);
        this.Reset();
    }

    private void Reset() {
        if (!this.skipReset) {
            this.SetWidth(this.lbl.GetWidth() + this.paddingX + this.val.GetWidth());
            this.SetHeight(this.lbl.GetHeight());
            this.val.SetPosition(this.lbl.GetPosition().Clone());
            this.val.SetX(this.val.GetX() + this.lbl.GetWidth() + this.paddingX);
        }
    }

    public void SetFontSize(int sz) {
        this.val.GetFont().deriveFont(sz);
        this.lbl.GetFont().deriveFont(sz);
        this.Reset();
    }

    public int GetFontSize() {
        if (this.lbl != null) {
            return this.lbl.GetFont().getSize();
        }
        if (this.val != null) {
            return this.val.GetFont().getSize();
        }
        return 0;
    }

    public MmgFont GetLabel() {
        return this.lbl;
    }

    public void SetLabel(MmgFont ft) {
        this.lbl = ft;
        this.Reset();
    }

    public MmgFont GetValue() {
        return this.val;
    }

    public void SetValue(MmgFont ft) {
        this.val = ft;
        this.Reset();
    }

    public Font GetLabelFont() {
        return this.lbl.GetFont();
    }

    public void SetLabelFont(Font ft) {
        this.lbl.SetFont(ft);
        this.Reset();
    }

    public Font GetValueFont() {
        return this.val.GetFont();
    }

    public void SetValueFont(Font ft) {
        this.val.SetFont(ft);
        this.Reset();
    }

    @Override
    public void SetPosition(MmgVector2 v) {
        super.SetPosition(v);
        this.lbl.SetPosition(v);
        this.Reset();
    }

    @Override
    public void SetMmgColor(MmgColor c) {
        super.SetMmgColor(c);
        this.lbl.SetMmgColor(c);
        this.val.SetMmgColor(c);
    }

    @Override
    public void SetX(int x) {
        super.SetX(x);
        this.lbl.SetX(x);
        this.Reset();
    }

    @Override
    public void SetY(int y) {
        super.SetY(y);
        this.lbl.SetY(y);
        this.Reset();
    }

    @Override
    public void MmgDraw(MmgPen p) {
        if (this.GetIsVisible()) {
            p.DrawText(this.lbl);
            p.DrawText(this.val);
        }
    }

    public boolean Equals(MmgLabelValuePair r) {
        return this.GetLabel().Equals(r.GetLabel()) && this.GetValue().Equals(r.GetValue()) && this.GetPaddingX() == r.GetPaddingX();
    }
}

