/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import java.awt.Font;
import net.middlemind.MmgGameApiJava.MmgBase.MmgFont;
import net.middlemind.MmgGameApiJava.MmgBase.MmgHelper;

public class MmgFontData {
    public static final String DEFAULT_FONT_FAMILY = "Serif";
    public static final int DEFAULT_FONT_TYPE = 0;
    private static int fontSize = 18;
    private static int targetPixelHeight = 22;
    private static int targetPixelHeightScaled = 22;
    private static Font fontNorm = new Font("Serif", 0, fontSize);
    private static Font fontBold = new Font("Serif", 1, fontSize);
    private static Font fontItalic = new Font("Serif", 2, fontSize);
    private static MmgFont mmgFontNorm = new MmgFont(fontNorm);
    private static MmgFont mmgFontBold = new MmgFont(fontBold);
    private static MmgFont mmgFontItalic = new MmgFont(fontItalic);

    public MmgFontData() {
        MmgFontData.CalculateScale();
    }

    public static void CalculateScale() {
        int target;
        MmgFont fnt = new MmgFont(fontBold);
        int fntSize = 12;
        fnt.SetFontSize(fntSize);
        fnt.SetText("Font Test");
        int max = 50;
        int count = 0;
        targetPixelHeightScaled = target = MmgHelper.ScaleValue(targetPixelHeight);
        if (fnt.GetHeight() < target) {
            while (fnt.GetHeight() < target) {
                fnt.SetFontSize(++fntSize);
                fnt.SetText("Font Test");
                if (++count < max) continue;
                fntSize = 12;
                break;
            }
        } else {
            while (fnt.GetHeight() > target) {
                fnt.SetFontSize(--fntSize);
                fnt.SetText("Font Test");
                if (++count < max) continue;
                fntSize = 12;
                break;
            }
        }
        if (fntSize % 2 != 0) {
            ++fntSize;
        }
        fontSize = fntSize;
        fontNorm = new Font(DEFAULT_FONT_FAMILY, 0, fontSize);
        fontBold = new Font(DEFAULT_FONT_FAMILY, 1, fontSize);
        fontItalic = new Font(DEFAULT_FONT_FAMILY, 2, fontSize);
        mmgFontNorm = new MmgFont(fontNorm);
        mmgFontBold = new MmgFont(fontBold);
        mmgFontItalic = new MmgFont(fontItalic);
    }

    public static String ToString() {
        String ret = "";
        ret = ret + "Font Size: " + MmgFontData.GetFontSize() + System.lineSeparator();
        ret = ret + "Target Pixel Height (Unscaled): " + MmgFontData.GetTargetPixelHeight() + System.lineSeparator();
        ret = ret + "Target Pixel Height (Scaled): " + MmgHelper.ScaleValue(MmgFontData.GetTargetPixelHeight()) + System.lineSeparator();
        return ret;
    }

    public static Font CreateDefaultFont(int sz) {
        return new Font(DEFAULT_FONT_FAMILY, 0, sz);
    }

    public static Font CreateDefaultNormalFont(int sz) {
        return new Font(DEFAULT_FONT_FAMILY, 0, sz);
    }

    public static Font CreateDefaultBoldFont(int sz) {
        return new Font(DEFAULT_FONT_FAMILY, 1, sz);
    }

    public static Font CreateDefaultItalicFont(int sz) {
        return new Font(DEFAULT_FONT_FAMILY, 2, sz);
    }

    public static MmgFont CreateDefaultMmgFont(int sz) {
        return new MmgFont(MmgFontData.CreateDefaultFont(sz));
    }

    public static MmgFont CreateDefaultNormalMmgFont(int sz) {
        return new MmgFont(MmgFontData.CreateDefaultNormalFont(sz));
    }

    public static MmgFont CreateDefaultBoldMmgFont(int sz) {
        return new MmgFont(MmgFontData.CreateDefaultBoldFont(sz));
    }

    public static MmgFont CreateDefaultItalicMmgFont(int sz) {
        return new MmgFont(MmgFontData.CreateDefaultItalicFont(sz));
    }

    public static Font CreateDefaultFontSm() {
        return new Font(DEFAULT_FONT_FAMILY, 0, fontSize - 2);
    }

    public static Font CreateDefaultNormalFontSm() {
        return new Font(DEFAULT_FONT_FAMILY, 0, fontSize - 2);
    }

    public static Font CreateDefaultBoldFontSm() {
        return new Font(DEFAULT_FONT_FAMILY, 1, fontSize - 2);
    }

    public static Font CreateDefaultItalicFontSm() {
        return new Font(DEFAULT_FONT_FAMILY, 2, fontSize - 2);
    }

    public static Font CreateDefaultFontExtraSm() {
        return new Font(DEFAULT_FONT_FAMILY, 0, fontSize - 4);
    }

    public static Font CreateDefaultNormalFontExtraSm() {
        return new Font(DEFAULT_FONT_FAMILY, 0, fontSize - 4);
    }

    public static Font CreateDefaultBoldFontExtraSm() {
        return new Font(DEFAULT_FONT_FAMILY, 1, fontSize - 4);
    }

    public static Font CreateDefaultItalicFontExtraSm() {
        return new Font(DEFAULT_FONT_FAMILY, 2, fontSize - 4);
    }

    public static MmgFont CreateDefaultMmgFontSm() {
        return new MmgFont(MmgFontData.CreateDefaultFontSm());
    }

    public static MmgFont CreateDefaultNormalMmgFontSm() {
        return new MmgFont(MmgFontData.CreateDefaultNormalFontSm());
    }

    public static MmgFont CreateDefaultBoldMmgFontSm() {
        return new MmgFont(MmgFontData.CreateDefaultBoldFontSm());
    }

    public static MmgFont CreateDefaultItalicMmgFontSm() {
        return new MmgFont(MmgFontData.CreateDefaultItalicFontSm());
    }

    public static Font CreateDefaultFontLg() {
        return new Font(DEFAULT_FONT_FAMILY, 0, fontSize + 2);
    }

    public static Font CreateDefaultNormalFontLg() {
        return new Font(DEFAULT_FONT_FAMILY, 0, fontSize + 2);
    }

    public static Font CreateDefaultBoldFontLg() {
        return new Font(DEFAULT_FONT_FAMILY, 1, fontSize + 2);
    }

    public static Font CreateDefaultItalicFontLg() {
        return new Font(DEFAULT_FONT_FAMILY, 2, fontSize + 2);
    }

    public static MmgFont CreateDefaultMmgFontLg() {
        return new MmgFont(MmgFontData.CreateDefaultFontLg());
    }

    public static MmgFont CreateDefaultNormalMmgFontLg() {
        return new MmgFont(MmgFontData.CreateDefaultNormalFontLg());
    }

    public static MmgFont CreateDefaultBoldMmgFontLg() {
        return new MmgFont(MmgFontData.CreateDefaultBoldFontLg());
    }

    public static MmgFont CreateDefaultItalicMmgFontLg() {
        return new MmgFont(MmgFontData.CreateDefaultItalicFontLg());
    }

    public static int GetFontSize() {
        return fontSize;
    }

    public static void SetFontSize(int fontSize) {
        MmgFontData.fontSize = fontSize;
    }

    public static int GetTargetPixelHeight() {
        return targetPixelHeight;
    }

    public static void SetTargetPixelHeight(int targetPixelHeight) {
        MmgFontData.targetPixelHeight = targetPixelHeight;
    }

    public static int GetTargetPixelHeightScaled() {
        return targetPixelHeightScaled;
    }

    public static void SetTargetPixelHeightScaled(int t) {
        targetPixelHeightScaled = t;
    }

    public static Font GetFontNorm() {
        return fontNorm;
    }

    public static void SetFontNorm(Font tfNorm) {
        fontNorm = tfNorm;
    }

    public static Font GetFontBold() {
        return fontBold;
    }

    public static void SetFontBold(Font tfBold) {
        fontBold = tfBold;
    }

    public static Font GetFontItalic() {
        return fontItalic;
    }

    public static void SetFontItalic(Font tfItac) {
        fontItalic = tfItac;
    }

    public static MmgFont GetMmgFontNorm() {
        return mmgFontNorm;
    }

    public static void SetMmgFontNorm(MmgFont mmgFontNorm) {
        MmgFontData.mmgFontNorm = mmgFontNorm;
    }

    public static MmgFont GetMmgFontBold() {
        return mmgFontBold;
    }

    public static void SetMmgFontBold(MmgFont mmgFontBold) {
        MmgFontData.mmgFontBold = mmgFontBold;
    }

    public static MmgFont GetMmgFontItalic() {
        return mmgFontItalic;
    }

    public static void SetMmgFontItalic(MmgFont mmgFontItalic) {
        MmgFontData.mmgFontItalic = mmgFontItalic;
    }
}

