/*
 * Decompiled with CFR 0.152.
 */
package net.middlemind.MmgGameApiJava.MmgBase;

import java.util.ArrayList;
import net.middlemind.MmgGameApiJava.MmgBase.MmgObj;
import net.middlemind.MmgGameApiJava.MmgBase.MmgPen;
import net.middlemind.MmgGameApiJava.MmgBase.MmgVector2;

public class MmgContainer
extends MmgObj {
    public static int INITIAL_SIZE = 10;
    private ArrayList<MmgObj> container;
    private Object[] a;
    private MmgObj mo;
    private int i;

    public MmgContainer() {
        this.SetContainer(new ArrayList<MmgObj>(INITIAL_SIZE));
    }

    public MmgContainer(MmgObj obj) {
        super(obj);
    }

    public MmgContainer(ArrayList<MmgObj> objects) {
        this.SetContainer(objects);
    }

    public MmgContainer(MmgContainer cont) {
        ArrayList<MmgObj> tmp1 = cont.GetContainer();
        if (tmp1 != null) {
            int len = tmp1.size();
            ArrayList<MmgObj> tmp2 = new ArrayList<MmgObj>(len);
            for (int j = 0; j < len; ++j) {
                tmp2.add(j, tmp1.get(j).Clone());
            }
            this.SetContainer(tmp2);
        } else {
            this.SetContainer(tmp1);
        }
        if (cont.GetPosition() != null) {
            this.SetPosition(cont.GetPosition().Clone());
        } else {
            this.SetPosition(cont.GetPosition());
        }
        this.SetWidth(cont.GetWidth());
        this.SetHeight(cont.GetHeight());
        this.SetIsVisible(cont.GetIsVisible());
        if (cont.GetMmgColor() != null) {
            this.SetMmgColor(cont.GetMmgColor().Clone());
        } else {
            this.SetMmgColor(cont.GetMmgColor());
        }
    }

    @Override
    public MmgObj Clone() {
        MmgContainer ret = new MmgContainer(this);
        return ret;
    }

    public void Add(MmgObj obj) {
        if (obj != null && this.container.add(obj)) {
            this.StampChild(obj);
        }
    }

    public void AddAt(int idx, MmgObj obj) {
        if (obj != null) {
            this.container.add(idx, obj);
        }
    }

    public void Remove(MmgObj obj) {
        if (obj != null && this.container.remove(obj)) {
            this.UnstampChild(obj);
        }
    }

    public MmgObj RemoveAt(int idx) {
        MmgObj obj = this.container.remove(idx);
        if (obj != null) {
            this.UnstampChild(obj);
        }
        return obj;
    }

    public int GetCount() {
        return this.container.size();
    }

    public Object[] GetArray() {
        return this.container.toArray();
    }

    public MmgObj GetAt(int idx) {
        return this.container.get(idx);
    }

    public void Clear() {
        this.UpdateAllChildren(ChildAction.UNSTAMP);
        this.container.clear();
    }

    public ArrayList<MmgObj> GetContainer() {
        return this.container;
    }

    public void SetContainer(ArrayList<MmgObj> aTmp) {
        if (aTmp != null) {
            this.container = aTmp;
            this.UpdateAllChildren(ChildAction.STAMP);
        } else {
            this.container = new ArrayList(INITIAL_SIZE);
        }
    }

    private void UpdateAllChildren(ChildAction act) {
        int len = this.GetCount();
        for (int j = 0; j < len; ++j) {
            MmgObj obj = this.container.get(j);
            if (obj == null) continue;
            if (act == ChildAction.STAMP) {
                this.StampChild(obj);
                continue;
            }
            this.UnstampChild(obj);
        }
    }

    private void StampChild(MmgObj obj) {
        if (obj != null) {
            obj.SetHasParent(true);
            obj.SetParent(this);
        }
    }

    private void UnstampChild(MmgObj obj) {
        if (obj != null) {
            obj.SetHasParent(false);
            obj.SetParent(null);
        }
    }

    public MmgObj GetChildAt(int idx) {
        return this.container.get(idx);
    }

    public MmgVector2 GetChildPosRelative(int idx) {
        MmgObj obj = this.container.get(idx);
        MmgVector2 v1 = new MmgVector2();
        v1.SetX(obj.GetX() - this.GetX());
        v1.SetY(obj.GetY() - this.GetY());
        return v1;
    }

    public MmgVector2 GetChildPosAbsolute(int idx) {
        return this.container.get(idx).GetPosition();
    }

    @Override
    public void MmgDraw(MmgPen p) {
        if (this.GetIsVisible()) {
            this.a = this.container.toArray();
            this.i = 0;
            while (this.i < this.a.length) {
                this.mo = (MmgObj)this.a[this.i];
                if (this.mo != null && this.mo.GetIsVisible()) {
                    this.mo.MmgDraw(p);
                }
                ++this.i;
            }
        }
    }

    @Override
    public boolean MmgUpdate(int updateTicks, long currentTimeMs, long msSinceLastFrame) {
        boolean ret = false;
        if (this.GetIsVisible()) {
            this.a = this.container.toArray();
            this.i = 0;
            while (this.i < this.a.length) {
                this.mo = (MmgObj)this.a[this.i];
                if (this.mo != null && this.mo.GetIsVisible() && this.mo.MmgUpdate(updateTicks, currentTimeMs, msSinceLastFrame)) {
                    ret = true;
                }
                ++this.i;
            }
        }
        return ret;
    }

    private static enum ChildAction {
        STAMP,
        UNSTAMP;

    }
}

